<?php
session_start();

// Sprawdź, czy użytkownik jest zalogowany
if (!isset($_SESSION['user'])) {
    // Jeżeli nie, przekieruj na stronę logowania
    header('Location: ../auth/login.php');
    exit;
}
?>

<?php
// index.php

// Stała do debugowania (ustaw na false na produkcji)
define('DEBUG_MODE', true);

// Dołącz plik z połączeniem do bazy
require_once '../api/db_connect.php';

// Próba połączenia
$conn = connectToDatabase();

// Jeśli połączenie nieudane, pokaż błąd i zakończ wykonywanie skryptu
if (!$conn) {
    require_once '../assets/templates/db-error.php';
    exit();
}
?>

<!DOCTYPE html>
<html lang="pl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Produkty - VAIOPanel</title>
  <script src="https://unpkg.com/lucide@latest"></script>
  <link rel="stylesheet" href="../assets/css/products-page.css" />
  <link rel="stylesheet" href="../assets/css/productEdit_widget.css" />
  <style>
    </style>
</head>
<body>
  <div class="dashboard-container">
    <!-- Sidebar -->
    <aside class="sidebar">
      <div class="brand">AZDash</div>
      <nav class="nav">
      <a href="./index.php" class="nav-link"><i data-lucide="layout-dashboard"></i> Dashboard</a>
        <a href="/users.html" class="nav-link"><i data-lucide="users"></i> Użytkownicy</a>
        <a href="./products.php" class="nav-link active"><i data-lucide="folder"></i> Produkty</a>
        <a href="/settings.html" class="nav-link"><i data-lucide="settings"></i> Ustawienia</a>
      </nav>
      <div class="logout">
        <a href="#" class="logout-link"><i data-lucide="log-out"></i> Wyloguj</a>
      </div>
    </aside>

    <!-- Main content -->
    <div class="main-content">
      <header class="topbar">
        <div>
          <h1 class="title">Produkty</h1>
          <p class="subtitle">Zarządzaj produktami w swoim sklepie</p>
        </div>
           <div class="user-panel">
          <button id="notificationButton" class="icon-button">
            <i data-lucide="bell"></i>
          </button>
          
          
          <div id="notificationMenu" class="notification-menu">
            <div class="notification-header">
              <h3>Powiadomienia</h3>
              <button class="clear-all">Wyczyść wszystko</button>
            </div>
            <ul class="notification-list">
              <li class="notification-item" data-id="1">
                <p>Nowe wiadomości od klienta</p>
                <span class="time">5 min temu</span>
              </li>
              <li class="notification-item" data-id="2">
                <p>Sprzedaż osiągnęła nowy rekord</p>
                <span class="time">1 godz. temu</span>
              </li>
              <li class="notification-item" data-id="3">
                <p>Twoje konto zostało zweryfikowane</p>
                <span class="time">2 godz. temu</span>
              </li>
            </ul>
            
          </div>
          
          <div id="modal-notify" class="modal-notify hidden">
  <div class="modal-header">
    <h2>Szczegóły powiadomienia</h2>
    <button onclick="closeModal()" class="close-btn"><i data-lucide="x"></i></button>
  </div>
  <div class="modal-body">
    <p class="notification-content">Ładowanie...</p>
    <div class="notification-actions">
      <!-- Akcje jak Wyczyść powiadomienie -->
    </div>
  </div>
    </div>
      <img src="https://i.pravatar.cc/40?img=12" alt="Avatar" class="avatar" onclick="openModal('modal-profile')"/>
    </div>
      </header>

      <main class="main">
        <div class="cards">
<div id="editProductWidget" class="card hidden">
    <div class="card-header">
        <h2>Edytuj produkt</h2>
        <i data-lucide="edit" class="icon-blue"></i>
    </div>
    <div class="card-body">
        <form id="editProductForm">
            <input type="hidden" id="editProductId" name="productId" />

            <div class="form-group">
                <label for="editProductName">Nazwa produktu</label>
                <input type="text" id="editProductName" name="productName" placeholder="Nazwa produktu" required />
            </div>

            <div class="form-group">
                <label for="editProductPrice">Cena</label>
                <input type="number" id="editProductPrice" name="productPrice" placeholder="Cena" required />
            </div>

            <div class="form-group">
                <label for="editProductDescription">Opis</label>
                <textarea id="editProductDescription" name="productDescription" rows="4" placeholder="Opis produktu" required></textarea>
            </div>

            <button type="submit" class="btn-submit">Zapisz zmiany</button>
        </form>
    </div>
    <div class="card-footer">
        <button onclick="closeEditWidget()" class="btn-cancel">Anuluj</button>
    </div>
</div>



 <script>
function openEditWidget(button) {
    const productId = button.getAttribute('data-id');

    fetch(`../api/get_product.php?id=${productId}`)
        .then(response => response.json())
        .then(data => {
            console.log(data);

            if (data.status === 'success') {
                const product = data.product;

                document.getElementById('editProductId').value = product.id;
                document.getElementById('editProductName').value = product.name;
                document.getElementById('editProductPrice').value = product.price;
                document.getElementById('editProductDescription').value = product.description;

                const editWidget = document.getElementById('editProductWidget');
                editWidget.classList.remove('hidden');
                editWidget.classList.add('show');
            } else {
                alert("Nie udało się pobrać danych produktu.");
            }
        })
        .catch(error => {
            console.error('Błąd:', error);
            alert("Wystąpił błąd podczas ładowania danych produktu.");
        });
}


function closeEditWidget() {
    const editWidget = document.getElementById('editProductWidget');
    editWidget.classList.add('hidden'); // Można rozważyć usunięcie tej linii, jeśli #editProductWidget domyślnie ma display: none
    editWidget.classList.remove('show'); // To jest kluczowe
}
// Upewnij się, że druga definicja tej funkcji została usunięta z kodu JS.

document.getElementById('editProductForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const formData = new FormData(this);

    fetch('../api/edit_product.php', {
      method: 'POST',
      body: formData
    })
    .then(response => response.text())
    .then(result => {
      alert(result);  // Debugujmy wynik odpowiedzi serwera
      setTimeout(() => {
        closeEditWidget();
        location.reload(); // Przeładuj stronę po zapisaniu
      }, 1000);
    })
    .catch(error => {
      alert('Wystąpił błąd przy edytowaniu produktu.');
      console.error('Błąd:', error);
    });
});

</script>



          <!-- Widget 1: Lista produktów -->
          <div class="card">
            <div class="card-header">
              <h2>Lista produktów</h2>
              <i data-lucide="box" class="icon-blue"></i>
            </div>
<?php
require_once '../api/db_connect.php';

$sql = "SELECT * FROM products";
$result = mysqli_query($conn, $sql);

echo '<table class="orders-table">
        <thead>
          <tr>
            <th>Nazwa produktu</th>
            <th>Cena</th>
            <th>Akcje</th>
          </tr>
        </thead>
        <tbody>';

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $id = htmlspecialchars($row['id']);
        $name = htmlspecialchars($row['name'], ENT_QUOTES);
        $price = htmlspecialchars($row['price']);
        $description = htmlspecialchars($row['description'] ?? '', ENT_QUOTES);

        echo "<tr>
                <td>$name</td>
                <td>" . $price . " PLN</td> <!-- Poprawiona linia -->
                <td>
                    <button class='btn-edit' data-id='$id' onclick='openEditWidget(this)'>Edytuj</button>
<button class='btn-delete' onclick='deleteProduct($id, this)'>Usuń</button>

                </td>
              </tr>";
    }
} else {
    echo "<tr><td colspan='3'>Brak produktów w bazie</td></tr>";
}

echo '</tbody></table>';

mysqli_close($conn);
?>


          </div>
        
          <!-- Widget 2: Formularz dodawania produktu -->
          <div class="card">
            <div class="card-header">
              <h2>Dodaj nowy produkt</h2>
              <i data-lucide="plus-circle" class="icon-blue"></i>
            </div>
            <div class="card-body">
             <form id="addProductForm">
  <div class="form-group">
    <label for="productName">Nazwa produktu</label>
    <input type="text" id="productName" name="productName" required />
  </div>
  <div class="form-group">
    <label for="productPrice">Cena</label>
    <input type="number" id="productPrice" name="productPrice" required />
  </div>
  <div class="form-group">
    <label for="productDescription">Opis</label>
    <textarea id="productDescription" name="productDescription" rows="4" required></textarea>
  </div>
  <button type="submit" class="btn-submit">Dodaj produkt</button>
</form>
<div id="formMessage"></div>


            </div>
          </div>
        </div>
        
      </main>
    </div>
  </div>


<script>
document.getElementById('addProductForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const form = this;
    const messageElement = document.getElementById('formMessage');
    messageElement.textContent = '';
    messageElement.style.color = '';

    try {
        const formData = new FormData(form);
        
        const response = await fetch('../api/add_product.php', {
            method: 'POST',
            body: formData
        });

        // Najpierw sprawdź status odpowiedzi
        if (!response.ok) {
            // Spróbuj odczytać odpowiedź jako JSON
            const errorResponse = await response.json().catch(() => null);
            const errorMessage = errorResponse?.message || await response.text();
            throw new Error(errorMessage || `HTTP error! status: ${response.status}`);
        }

        // Odczytaj odpowiedź tylko raz
        const data = await response.json();
        
        if (data.status === 'success') {
            messageElement.textContent = data.message;
            messageElement.style.color = 'green';
            form.reset();
            
            // Odśwież stronę po 1 sekundzie
            setTimeout(() => location.reload(), 1000);
        } else {
            throw new Error(data.message || 'Unknown error occurred');
        }

    } catch (error) {
        console.error('Error:', error);
        messageElement.textContent = 'Error: ' + error.message;
        messageElement.style.color = 'red';
        
        // Jeśli odpowiedź zawiera HTML, wyświetl ją w konsoli
        if (error.message.includes('<')) {
            console.log('Raw server response:', error.message);
        }
    }
});

</script>
<script>
  function deleteProduct(id, buttonElement) {
  if (!confirm("Na pewno chcesz usunąć ten produkt?")) return;

  fetch(`../api/delete_product.php?id=${id}`, {
    method: 'GET',
  })
  .then(response => response.text())
  .then(result => {
    console.log("Usuwanie:", result);
    // Opcjonalnie: usuń wiersz z tabeli bez przeładowania
    const row = buttonElement.closest('tr');
    if (row) row.remove();
  })
  .catch(error => {
    alert('Wystąpił błąd podczas usuwania produktu.');
    console.error('Błąd:', error);
  });
}

  </script>
<script>
  lucide.createIcons();
</script>
<script src="../assets/js/notify.js"></script>
</body>
</html>
