<!DOCTYPE html>
<html lang="pl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Nowoczesna Strona Logowania</title>
  <script src="https://unpkg.com/lucide@latest"></script>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="../assets/css/login-page.css">
  <!-- <link rel="stylesheet" href="../assets/css/.theme/login-page.dark.css"> -->
</head>
<body>
  <div class="container">
    <div class="card">
      <h2 class="branding"><span class="one-part">AZURA </span>Systems</h2>
      <div class="header"> 
        <h2 class="title">Zaloguj się</h2>
      <!--  <button id="toggle-theme" class="theme-toggle">
          <i data-lucide="moon" class="dark-hidden icon"></i>
          <i data-lucide="sun" class="dark-inline icon"></i>
        </button> -->
      </div>

      <form id="login-form" class="form" action="../dashboard/">
        <div class="form-group">
          <label class="label">Email</label>
          <input type="email" required placeholder="twoj@email.com" class="input">
        </div>

        <div class="form-group password-container">
          <label class="label">Hasło</label>
          <input type="password" id="password" required placeholder="••••••••" class="input">
         <!-- <button type="button" id="toggle-password" class="password-toggle">
            <i data-lucide="eye" id="eye-icon" class="icon"></i>
          </button> -->
        </div>

        <div class="form-options">
         <label class="remember-me">
            <input type="checkbox">
            Zapamiętaj mnie
          </label>
          <a href="#" class="forgot-password">Zapomniałeś hasła?</a>
        </div>

        <button type="submit" class="submit-btn">
          Zaloguj się
        </button>
      </form>

      <p class="register-text">Nie masz konta? <a href="#" class="register-link">Zarejestruj się</a></p>
    </div>
  </div>

  <script>
  document.addEventListener('DOMContentLoaded', function () {
    lucide.createIcons();

    const togglePasswordBtn = document.getElementById('toggle-password');
    const passwordInput = document.getElementById('password');
    const eyeIcon = document.getElementById('eye-icon');
togglePasswordBtn.addEventListener('click', () => {
  const isHidden = passwordInput.type === 'password';
  passwordInput.type = isHidden ? 'text' : 'password';

  // Stwórz nową ikonę
  const newIcon = document.createElement('i');
  newIcon.setAttribute('data-lucide', isHidden ? 'eye-off' : 'eye');
  
  // Podmień starą ikonę
  eyeIcon.replaceWith(newIcon);

  // Wygeneruj nowe ikony
  lucide.createIcons();
});


    const toggleThemeBtn = document.getElementById('toggle-theme');
    if (toggleThemeBtn) {
      toggleThemeBtn.addEventListener('click', () => {
        const isDark = document.documentElement.classList.toggle('dark');
        localStorage.setItem('darkMode', isDark);
        lucide.createIcons();
      });
    }

    if (localStorage.getItem('darkMode') === 'true') {
      document.documentElement.classList.add('dark');
    }
  });
</script>

</body>
</html>