<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


session_start();


if (isset($_SESSION['blocked_user']) && $_SESSION['blocked_user'] === true) {
  http_response_code(403);
  echo <<<HTML
<!DOCTYPE html>
<html lang="pl">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>403 Forbidden - AZShop</title>
<style>
  body {
    margin: 0;
    font-family: 'Inter', sans-serif;
    background: #f8f9fa;
    color: #343a40;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    height: 100vh;
    text-align: center;
    padding: 20px;
  }
  h1 {
    font-size: 6rem;
    margin: 0;
    color: #dc3545;
    user-select: none;
  }
  h2 {
    margin: 10px 0 20px;
    font-weight: 700;
  }
  p {
    font-size: 1.25rem;
    margin-bottom: 30px;
    max-width: 400px;
    line-height: 1.4;
  }
  a.button {
    display: inline-block;
    padding: 12px 30px;
    background-color: #dc3545;
    color: #fff;
    text-decoration: none;
    font-weight: 600;
    border-radius: 5px;
    box-shadow: 0 4px 8px rgb(220 53 69 / 0.3);
    transition: background-color 0.3s ease;
  }
  a.button:hover {
    background-color: #b02a37;
  }
</style>
</head>
<body>
<script>
  setTimeout(() => {
    window.location.href = '/';
  }, 5000);
</script>

<h1>403</h1>
<h2>Forbidden</h2>
<p>Twój dostęp został zablokowany po 3 nieudanych próbach logowania.</p>
<a href="/" class="button">Wróć do strony głównej</a>
</body>
</html>
HTML;
  exit;
}



require_once __DIR__ . '/../config.php'; // Poprawiona ścieżka

// Połączenie z bazą danych
try {
    $db = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4", DB_USER, DB_PASS);
    // Ustawienie trybu błędów PDO
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Zmiana stałej na PDO::ERRMODE_EXCEPTION
} catch(PDOException $e) {
    die("Błąd połączenia z bazą danych: " . $e->getMessage());
}

// Obsługa logowania
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = $_POST['email'] ?? '';
  $password = $_POST['password'] ?? '';

  // Sprawdź, czy użytkownik jest zablokowany
  if (isset($_SESSION['blocked_user']) && $_SESSION['blocked_user'] === true) {
      $error = 'Twoje konto zostało zablokowane po 3 nieudanych próbach logowania.';
  } else {
      $stmt = $db->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
      $stmt->execute([$email]);
      $user = $stmt->fetch(PDO::FETCH_ASSOC);

      if ($user && password_verify($password, $user['password'])) {
          if ($user['role'] === 'admin') {
              // Resetujemy licznik prób użytkowników przy poprawnym logowaniu admina
              unset($_SESSION['login_attempts_user']);
              unset($_SESSION['blocked_user']);

              $_SESSION['user'] = [
                  'id' => $user['id'],
                  'username' => $user['username'],
                  'email' => $user['email'],
                  'role' => $user['role']
              ];

              header('Location: ../dashboard/');
              exit;
          } else {
              // Jeśli rola user, blokujemy dostęp do logowania
              // Zwiększamy licznik prób i blokujemy po 3 próbach

              // Inicjalizacja licznika jeśli brak
              if (!isset($_SESSION['login_attempts_user'])) {
                  $_SESSION['login_attempts_user'] = 0;
              }

              $_SESSION['login_attempts_user']++;

              if ($_SESSION['login_attempts_user'] >= 3) {
                  $_SESSION['blocked_user'] = true;
                  $error = 'Twoje konto zostało zablokowane po 3 nieudanych próbach logowania.';
              } else {
                  $error = 'Dostęp mają tylko administratorzy.';
              }
          }
      } else {
          // Niepoprawny email lub hasło, inkrementujemy licznik jeśli użytkownik istnieje i ma rolę user
          if ($user && $user['role'] === 'user') {
              if (!isset($_SESSION['login_attempts_user'])) {
                  $_SESSION['login_attempts_user'] = 0;
              }
              $_SESSION['login_attempts_user']++;

              if ($_SESSION['login_attempts_user'] >= 3) {
                  $_SESSION['blocked_user'] = true;
                  $error = 'Twoje konto zostało zablokowane po 3 nieudanych próbach logowania.';
              } else {
                  $error = 'Nieprawidłowy email lub hasło';
              }
          } else {
              $error = 'Nieprawidłowy email lub hasło';
          }
      }
  }
}

?>


<!DOCTYPE html>
<html lang="pl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Logowanie - AZShop</title>
  <script src="https://unpkg.com/lucide@latest"></script>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="../assets/css/login-page.css">
</head>
<body>
  <div class="container">
    <div class="card">
      <h2 class="branding"><span class="one-part">AZ</span>Shop</h2>
      <div class="header"> 
        <h2 class="title">Zaloguj się</h2>
      </div>

      <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
      <?php endif; ?>

      <form id="login-form" class="form" method="POST">

        <div class="form-group">
          <label class="label">Email</label>
          <input type="email" name="email" required placeholder="twoj@email.com" class="input" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
        </div>

        <div class="form-group password-container">
          <label class="label">Hasło</label>
          <input type="password" id="password" name="password" required placeholder="••••••••" class="input">
        </div>

        <div class="form-options">
          <label class="remember-me">
            <input type="checkbox" name="remember" <?php echo isset($_POST['remember']) ? 'checked' : ''; ?>>
            Zapamiętaj mnie
          </label>
          <a href="#" class="forgot-password">Zapomniałeś hasła?</a>
        </div>

        <button type="submit" class="submit-btn">
          Zaloguj się
        </button>
      </form>

      <p class="register-text">Nie masz konta? <a href="#" class="register-link">Skontaktuj się z administratorem</a></p>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', function () {
      lucide.createIcons();
    });
  </script>
</body>
</html>