<?php
require_once 'db_connect.php';

header('Content-Type: application/json');

// Sprawdź czy ID zostało przekazane
if (!isset($_GET['id'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Brak ID produktu']);
    exit;
}

$id = intval($_GET['id']);

// Połącz z bazą
$conn = connectToDatabase();
if (!$conn) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Błąd połączenia z bazą danych']);
    exit;
}

// Przygotuj zapytanie
$stmt = $conn->prepare("SELECT id, name, price, description FROM products WHERE id = ?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    $result = $stmt->get_result();
    $product = $result->fetch_assoc();

    if ($product) {
        echo json_encode(['status' => 'success', 'product' => $product]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Produkt nie znaleziony']);
    }
} else {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Błąd zapytania']);
}

$stmt->close();
$conn->close();
?>
