<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'db_connect.php';

$db = connectToDatabase();

if (!$db) {
    http_response_code(500);
    echo json_encode(["error" => "Nie udało się połączyć z bazą danych"]);
    exit;
}

$user = $_SESSION['user'] ?? null;
if (!$user || !isset($user['id']) || !is_numeric($user['id'])) {
    http_response_code(403);
    echo json_encode(["error" => "Brak dostępu"]);
    exit;
}
$user_id = $user['id'];


$stmt = $db->prepare("DELETE FROM notifications WHERE user_id = ?");
if (!$stmt) {
    http_response_code(500);
    echo json_encode(["error" => "Błąd przygotowania zapytania"]);
    exit;
}

$stmt->bind_param("i", $user_id);

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(["error" => "Błąd wykonania zapytania"]);
    exit;
}

$stmt->close();


echo json_encode(["status" => "success"]);
exit;
?>