document.addEventListener('DOMContentLoaded', function() {
    const formSections = document.querySelectorAll('.form-section');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const submitBtn = document.getElementById('submitBtn');
    const progressSteps = document.querySelectorAll('.progress-step');
    const passwordInput = document.getElementById('admin_password');
    const passwordStrengthBar = document.querySelector('.strength-bar');
    const passwordStrengthText = document.querySelector('.strength-text');
    
    let currentSection = 0;
    
    // Inicjalizacja - pokaż pierwszą sekcję
    showSection(currentSection);
    
    // Obsługa przycisku "Dalej"
    nextBtn.addEventListener('click', function() {
        if (validateCurrentSection()) {
            currentSection++;
            showSection(currentSection);
            updateProgressBar();
        }
    });
    
    // Obsługa przycisku "Wstecz"
    prevBtn.addEventListener('click', function() {
        currentSection--;
        showSection(currentSection);
        updateProgressBar();
    });
    
    // Walidacja hasła w czasie rzeczywistym
    passwordInput.addEventListener('input', function() {
        const password = passwordInput.value;
        const strength = calculatePasswordStrength(password);
        updatePasswordStrengthUI(strength);
    });
    
    // Funkcja pokazująca aktualną sekcję formularza
    function showSection(index) {
        formSections.forEach((section, i) => {
            section.classList.toggle('active', i === index);
        });
        
        // Ukryj/pokaż przyciski nawigacji
        prevBtn.disabled = index === 0;
        nextBtn.style.display = index === formSections.length - 1 ? 'none' : 'block';
        submitBtn.style.display = index === formSections.length - 1 ? 'block' : 'none';
    }
    
    // Funkcja aktualizująca pasek postępu
    function updateProgressBar() {
        progressSteps.forEach((step, i) => {
            if (i < currentSection) {
                step.classList.add('completed');
                step.classList.add('active');
            } else if (i === currentSection) {
                step.classList.add('active');
                step.classList.remove('completed');
            } else {
                step.classList.remove('active', 'completed');
            }
        });
    }
    
    // Funkcja walidująca aktualną sekcję
    function validateCurrentSection() {
        const currentSectionElement = formSections[currentSection];
        const inputs = currentSectionElement.querySelectorAll('input[required], select[required]');
        let isValid = true;
        
        inputs.forEach(input => {
            if (!input.value.trim()) {
                input.style.borderColor = 'var(--error-color)';
                isValid = false;
            } else {
                input.style.borderColor = 'var(--border-color)';
            }
        });
        
        // Dodatkowa walidacja dla hasła
        if (currentSection === 1) {
            const password = document.getElementById('admin_password').value;
            const confirmPassword = document.getElementById('admin_password_confirm').value;
            
            if (password !== confirmPassword) {
                document.getElementById('admin_password_confirm').style.borderColor = 'var(--error-color)';
                alert('Hasła nie są identyczne!');
                isValid = false;
            }
        }
        
        return isValid;
    }
    
    // Funkcja obliczająca siłę hasła
    function calculatePasswordStrength(password) {
        let strength = 0;
        
        // Długość hasła
        if (password.length > 7) strength += 1;
        if (password.length > 11) strength += 1;
        
        // Obecność różnych znaków
        if (/[A-Z]/.test(password)) strength += 1;
        if (/[a-z]/.test(password)) strength += 1;
        if (/[0-9]/.test(password)) strength += 1;
        if (/[^A-Za-z0-9]/.test(password)) strength += 1;
        
        return Math.min(strength, 5);
    }
    
    // Funkcja aktualizująca UI siły hasła
    function updatePasswordStrengthUI(strength) {
        const bar = passwordStrengthBar.querySelector('::after') || passwordStrengthBar;
        let color, text;
        
        switch(strength) {
            case 0:
            case 1:
                color = '#dc3545'; // czerwony
                text = 'Bardzo słabe';
                break;
            case 2:
                color = '#fd7e14'; // pomarańczowy
                text = 'Słabe';
                break;
            case 3:
                color = '#ffc107'; // żółty
                text = 'Średnie';
                break;
            case 4:
                color = '#28a745'; // zielony
                text = 'Silne';
                break;
            case 5:
                color = '#20c997'; // turkusowy
                text = 'Bardzo silne';
                break;
        }
        
        passwordStrengthBar.style.setProperty('--strength-color', color);
        passwordStrengthBar.style.width = `${strength * 20}%`;
        passwordStrengthBar.style.backgroundColor = color;
        passwordStrengthText.textContent = text;
        passwordStrengthText.style.color = color;
    }
});